//\frame{
import java.io.*;
import java.util.*;


public class PTC {
  private FileInputStream file;
  private StreamTokenizer st;
  SlideConnection SC;  

  
  private int slideCount=0;
  
  public int getSlideCount(){return slideCount;};
  
  
  String StartOrd="begin{slide}";
  String StopOrd="end{slide}";

  PTC(String filename)
    throws FileNotFoundException {
    try {
      file = new FileInputStream(filename);
      st = new StreamTokenizer(file);

      SC = new SlideConnection();


      st.resetSyntax();
      st.eolIsSignificant(true);
      st.wordChars(48,57);
      st.wordChars(65,90);
      st.wordChars(97,122);
      st.wordChars(123,123);
      st.wordChars(125,125);
      
      
      st.ordinaryChars(32,32);
      st.ordinaryChar('\'');

      
    } catch(FileNotFoundException e) {
      System.out.println(
        "Could not open " + filename);
      throw e;
    }
  }
  void cleanup() {
    try {
      file.close();
    } catch(IOException e) {
      System.out.println(
        "file.close() unsuccessful");
    }
  }
  void showHappen() {
    try {
      boolean withinSlide=false;
      boolean commentRow=false;
      boolean commentRowEnd=false;
      
      slideCount=0;
      
      String lastString="";
      String mem="";
      String s="";
      
      while(st.nextToken() != StreamTokenizer.TT_EOF) 
      {
        lastString=s;
        switch(st.ttype) {
          case StreamTokenizer.TT_EOL:
            s = new String("\n");
            commentRowEnd=true;
            break;
          case StreamTokenizer.TT_WORD:
            s = st.sval; // Already a String
            break;
          default: // single character in ttype
            s = String.valueOf((char)st.ttype);
         
            // hier werden die LaTeX-Kommentare bercksichtigt
              if (s.equals("%")&&!lastString.equals("\\")&&!commentRow)
              {
                commentRow=true;
                commentRowEnd=false;
                // debug mode System.out.println("commentstart");
              }
            
        }
        if(!withinSlide&&s.equals(StartOrd)&&lastString.equals("\\")&&!commentRow)
        {
          // debug mode           
          System.out.println("****************************framestart");
          slideCount++;
          s="";
          withinSlide=true;
          continue;
        } else
        if(withinSlide&&s.equals(StopOrd)&&lastString.equals("\\")&&!commentRow)
        {  
          withinSlide=false;
//          System.out.println("");
          
          // debug mode           
          System.out.println("############################framestopp");
          continue;
        }
        if(withinSlide)System.out.print("["+lastString+"]");// debug mode         else System.out.print("["+lastString+"]");
//        if(withinSlide)if(s.length()>2)SC.doMySqlUpdate("insert ignore into wordindex (word) values (\""+s+"\");");
        if(commentRow&&commentRowEnd)commentRow=false;
        //System.out.print("["+s+"]");
      }
    System.out.println("");  
    System.out.println(slideCount+"Folien gefunden.");

      
    } catch(IOException e) {
      System.out.println(
        "st.nextToken() unsuccessful");
    }
    
  }

  public static void main(String[] args) {
    try {
      PTC wc =
        new PTC(args[0]);
      wc.showHappen();
      wc.cleanup();
    } catch(Exception e) {
      e.printStackTrace();
    }
  }
}
//}
